/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.condition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.common.quests.QuestProperties;
import dev.toma.gunsrpg.common.quests.condition.AbstractQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.IQuestCondition;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProviderSerializer;
import dev.toma.gunsrpg.common.quests.condition.QuestConditionProviderType;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import dev.toma.gunsrpg.util.properties.IPropertyReader;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DistanceConditionProvider
extends AbstractQuestConditionProvider<DistanceConditionProvider>
implements IQuestCondition {
    private final ITextComponent[] descriptors;
    private final double minDistance;
    private final double maxDistance;

    public DistanceConditionProvider(QuestConditionProviderType<? extends DistanceConditionProvider> type, double minDistance, double maxDistance) {
        super(type);
        boolean isMaxDistanceDefined;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        boolean isMinDistanceDefined = minDistance > 0.0;
        boolean bl = isMaxDistanceDefined = maxDistance < 3.4028234663852886E38;
        this.descriptors = isMinDistanceDefined && isMaxDistanceDefined ? DistanceConditionProvider.expandWithShortLocalizations(new ITextComponent[]{new TranslationTextComponent(this.getLocalizationString(), new Object[]{minDistance, maxDistance})}) : DistanceConditionProvider.expandWithShortLocalizations(new ITextComponent[]{new TranslationTextComponent(this.getLocalizationString() + (isMinDistanceDefined ? ".min" : ".max"), new Object[]{isMinDistanceDefined ? minDistance : maxDistance})});
    }

    public static DistanceConditionProvider fromNbt(QuestConditionProviderType<DistanceConditionProvider> type, CompoundNBT nbt) {
        double min = nbt.func_74769_h("min");
        double max = nbt.func_74769_h("max");
        return new DistanceConditionProvider(type, min, max);
    }

    @Override
    public boolean isValid(PlayerEntity player, IPropertyReader reader) {
        LivingEntity entity = reader.getProperty(QuestProperties.ENTITY);
        double sqrDist = player.func_70068_e((Entity)entity);
        double distance = Math.sqrt(sqrDist);
        return distance >= this.minDistance && distance <= this.maxDistance;
    }

    @Override
    public ITextComponent getDescriptor(boolean shortDesc) {
        return this.descriptors[shortDesc ? 1 : 0];
    }

    @Override
    public DistanceConditionProvider makeConditionInstance() {
        return this;
    }

    @Override
    public IQuestConditionProvider<?> getProviderType() {
        return this;
    }

    @Override
    public void saveInternalData(CompoundNBT nbt) {
        nbt.func_74780_a("min", this.minDistance);
        nbt.func_74780_a("max", this.maxDistance);
    }

    public static final class Serializer
    implements IQuestConditionProviderSerializer<DistanceConditionProvider> {
        @Override
        public DistanceConditionProvider deserialize(QuestConditionProviderType<DistanceConditionProvider> conditionType, JsonElement data) {
            double max;
            JsonObject object = JsonHelper.asJsonObject(data);
            double min = JSONUtils.func_151221_a((JsonObject)object, (String)"min", (float)0.0f);
            if (min > (max = (double)JSONUtils.func_151221_a((JsonObject)object, (String)"max", (float)Float.MAX_VALUE))) {
                throw new JsonSyntaxException("Min distance cannot be larger than max distance!");
            }
            return new DistanceConditionProvider(conditionType, min, max);
        }
    }
}

